/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby.hyperlink;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.text.hyperlink.IndexQueryingHyperlinkDetector;
import com.aptana.editor.ruby.RubyEditorPlugin;
import com.aptana.editor.ruby.hyperlink.ResolutionTargetHyperlink;
import com.aptana.ruby.core.RubyCorePlugin;
import com.aptana.ruby.core.codeassist.CodeResolver;
import com.aptana.ruby.core.codeassist.ResolutionTarget;
import com.aptana.ruby.core.codeassist.ResolveContext;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.jrubyparser.ast.Node;
import org.jrubyparser.lexer.SyntaxException;

public class RubyHyperlinkDetector
extends IndexQueryingHyperlinkDetector {
    private IRegion srcRegion;

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        Node atOffset;
        ResolveContext context;
        ArrayList<ResolutionTargetHyperlink> hyperlinks;
        block11: {
            hyperlinks = new ArrayList<ResolutionTargetHyperlink>();
            IDocument doc = textViewer.getDocument();
            context = new ResolveContext(this.getURI(), doc.get(), region.getOffset());
            atOffset = context.getSelectedNode();
            if (atOffset != null) break block11;
            return null;
        }
        try {
            this.srcRegion = new Region(atOffset.getPosition().getStartOffset(), atOffset.getPosition().getEndOffset() - atOffset.getPosition().getStartOffset());
            CodeResolver resolver = RubyCorePlugin.getDefault().getCodeResolver();
            resolver.resolve(context);
            List resolved = context.getResolved();
            if (resolved != null) {
                for (ResolutionTarget target : resolved) {
                    hyperlinks.add(new ResolutionTargetHyperlink(this.srcRegion, target));
                }
            }
        }
        catch (SyntaxException syntaxException) {
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)RubyEditorPlugin.getDefault(), (Throwable)e);
        }
        try {
            if (hyperlinks.isEmpty()) {
                return null;
            }
            LinkedHashSet uniques = new LinkedHashSet(hyperlinks);
            IHyperlink[] iHyperlinkArray = uniques.toArray(new IHyperlink[uniques.size()]);
            return iHyperlinkArray;
        }
        finally {
            this.srcRegion = null;
        }
    }
}

